#include "m51em256evb.h"
#include "sci.h"
#include "kbi.h"

#include "validation.h"

#ifdef SCI_TEST1         

/*
 * see validation doc for details            
 */

unsigned char ReceivedData1;
unsigned char ReceivedData2;

void break_ten_bits(uint8 port)
{
    switch(port)
    {
      //SCI functions
      case 1:
           SCI1C1_M  = 0;      
           SCI1S2_BRK13 = 0;
           SCI1C2_SBK = 1;
           SCI1C2_SBK = 0;   /*queues a break character*/
        break;
        
      case 2:
           SCI2C1_M  = 0;
           SCI2S2_BRK13 = 0;
           SCI2C2_SBK = 1;
           SCI2C2_SBK = 0;   /*queues a break character*/
        break;
        
      case 3:
           SCI3C1_M  = 0;
           SCI3S2_BRK13 = 0;
           SCI3C2_SBK = 1;
           SCI3C2_SBK = 0;   /*queues a break character*/      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }   
}

void break_eleven_bits(uint8 port)
{
    switch(port)
    {
      //SCI functions
      case 1:
           SCI1C1_M  = 1;      // 13 bits will be transmitted on break detect
           SCI1S2_BRK13 = 0;
           SCI1C2_SBK = 1;
           SCI1C2_SBK = 0;   /*queues a break character*/
        break;
        
      case 2:
           SCI2C1_M  = 1;      // 13 bits will be transmitted on break detect
           SCI2S2_BRK13 = 0;
           SCI2C2_SBK = 1;
           SCI2C2_SBK = 0;   /*queues a break character*/     
        break;
        
      case 3:
           SCI3C1_M  = 1;      // 13 bits will be transmitted on break detect
           SCI3S2_BRK13 = 0;
           SCI3C2_SBK = 1;
           SCI3C2_SBK = 0;   /*queues a break character*/     
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }  
}

void break_thirteen_bits(uint8 port)
{
    switch(port)
    {
      //SCI functions
      case 1:
           SCI1C1_M  = 0;
           SCI1S2_BRK13 = 1;
           SCI1C2_SBK = 1;
           SCI1C2_SBK = 0;   /*queues a break character*/
        break;
        
      case 2:
           SCI2C1_M  = 0;
           SCI2S2_BRK13 = 1;
           SCI2C2_SBK = 1;
           SCI2C2_SBK = 0;   /*queues a break character*/     
        break;
        
      case 3:
           SCI3C1_M  = 0;
           SCI3S2_BRK13 = 1;
           SCI3C2_SBK = 1;
           SCI3C2_SBK = 0;   /*queues a break character*/      
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }  
}

void break_fourteen_bits(uint8 port)
{
    switch(port)
    {
      //SCI functions
      case 1:
           SCI1C1_M  = 1;      
           SCI1S2_BRK13 = 1;
           SCI1C2_SBK = 1;
           SCI1C2_SBK = 0;   /*queues a break character*/      
        break;
        
      case 2:
           SCI2C1_M  = 1;    
           SCI2S2_BRK13 = 1;
           SCI2C2_SBK = 1;
           SCI2C2_SBK = 0;   /*queues a break character*/       
        break;
        
      case 3:
           SCI3C1_M  = 1;      
           SCI3S2_BRK13 = 1;
           SCI3C2_SBK = 1;
           SCI3C2_SBK = 0;   /*queues a break character*/  
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }  
}
///////////////////////////////////////////

void SCI_init_LBDTIE(uint8 port, unsigned short br)
{
    switch(port)
    {
      //SCI functions
      case 1:
            /*SCI function*/
            PTBPF2_B2 = 3;
            PTBPF2_B3 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI1 = 1;
           
           SCI1BD = SCI1BD_LBKDIE_MASK | br;
           SCI1C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
           SCI1C2_TE = 1;      //enable transmitter
           SCI1C2_RE = 1;      //enable transmitter
           
           SCI1C2_RIE = 1;      //enable rx interrupt
           
           SCI1S2_LBKDE = 1;//enabling break interrupt
           
        break;
        
      case 2:
            /*SCI function*/
            PTBPF2_B0 = 3;
            PTBPF2_B1 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI2 = 1;
            
           SCI2BD = SCI2BD_LBKDIE_MASK | br;
           SCI2C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
           SCI2C2_TE = 1;      //enable transmitter
           SCI2C2_RE = 1;      //enable transmitter
           
           SCI2C2_RIE = 1;      //enable rx interrupt
                
        break;
        
      case 3:
            /*SCI function*/
            PTFPF2_F2 = 3;
            PTFPF2_F3 = 3;    

            /*starting SCI clock*/
            SCGC1_SCI3 = 1;       
          
            SCI3BD = SCI3BD_LBKDIE_MASK | br;
            SCI3C1 = 0x00;      //start + 8 data bits (LSB first) + stop       
            SCI3C2_TE = 1;      //enable transmitter
            SCI3C2_RE = 1;      //enable transmitter
            
            SCI3C2_RIE = 1;      //enable rx interrupt
           
        break;
        
      default:
        for(;;)
        ; //error
        break;
    }
}         

/***********************************************/
void interrupt VectorNumber_Vsci1rx SCI1_isrv() 
{
   vuint8 status;

   if(SCI1S2_LBKDIF) 
   {
      SCI1S2_LBKDIF=1;
      SCI_SendMsg(3,"BREAK Condition detected\n");
   }
   else
   {
     //if it's just a rx, toggle pin
     status = SCI1S1;
     status = SCI1D;
     SCI_SendMsg(3,"Character received\n");     
   }  
}  

void interrupt VectorNumber_Vsci2rx SCI2_isrv() 
{
   vuint8 status;

   if(SCI2S2_LBKDIF) 
   {
      SCI2S2_LBKDIF=1;
      SCI_SendMsg(3,"BREAK Condition detected\n");
   }
   else
   {
     //if it's just a rx, toggle pin
     status = SCI2S1;
     status = SCI2D;
     SCI_SendMsg(3,"Character received\n");
   }  
}

void interrupt VectorNumber_Vsci3rx SCI3_isrv() 
{
   vuint8 status;

   if(SCI3S2_LBKDIF) 
   {
      SCI3S2_LBKDIF=1;
      SCI_SendMsg(3,"BREAK Condition detected ");
   }
   else
   {
     status = SCI3S1;
     status = SCI3D;
     SCI_SendChr(3,status);
   }  
}
/***********************************************/
void interrupt VectorNumber_Vsci1err SCI1err_isrv() 
{
   vuint8 status;
   
   if(SCI1S1_OR)
   {
     SCI_SendMsg(3,"Error: OR ");
   }
   else if(SCI1S1_NF)
   {
     SCI_SendMsg(3,"Error: NF ");
   }
   else if(SCI1S1_FE)
   {
     SCI_SendMsg(3,"Error: FE ");    
   }
   else if(SCI1S1_PF)
   {
     SCI_SendMsg(3,"Error: PF ");     
   }
   /*clear it*/
   status = SCI1S1;
   status = SCI1D;
}

void interrupt VectorNumber_Vsci2err SCI2err_isrv() 
{
   vuint8 status;
   
   if(SCI2S1_OR)
   {
     SCI_SendMsg(3,"Error: OR ");
   }
   else if(SCI2S1_NF)
   {
     SCI_SendMsg(3,"Error: NF ");
   }
   else if(SCI2S1_FE)
   {
     SCI_SendMsg(3,"Error: FE ");    
   }
   else if(SCI2S1_PF)
   {
     SCI_SendMsg(3,"Error: PF ");     
   }
   /*clear it*/
   status = SCI2S1;
   status = SCI2D;
}

void interrupt VectorNumber_Vsci3err SCI3err_isrv() 
{
   vuint8 status;
   
   if(SCI3S1_OR)
   {
     SCI_SendMsg(3,"Error: OR ");
   }
   else if(SCI3S1_NF)
   {
     SCI_SendMsg(3,"Error: NF ");
   }
   else if(SCI3S1_FE)
   {
     SCI_SendMsg(3,"Error: FE ");    
   }
   else if(SCI3S1_PF)
   {
     SCI_SendMsg(3,"Error: PF ");     
   }
   /*clear it*/
   status = SCI3S1;
   status = SCI3D;
}
/***********************************************/

/*This function are called by the KBI interrupt */
void sw_301_click(void)  //PTD4
{
    break_ten_bits(1);
}
   
void sw_302_click(void)  //PTD5
{
    break_thirteen_bits(1);
}

void sw_303_click(void)  //PTD6
{
    break_eleven_bits(1);
}


void sw_304_click(void)  //PTD7
{
    break_fourteen_bits(1);
}

void sci_test1(void) 
{
  
  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  SCI_init_LBDTIE(1,BR_19200);//tx
  SCI_init_LBDTIE(2,BR_19200);//rx
  SCI_init_LBDTIE(3,BR_19200);//console

  /*error interrupts*/
  SCI2C3_ORIE = 1;
  SCI2C3_FEIE = 1;
  SCI2C3_NEIE = 1;
  SCI2C3_PEIE = 1;
  
  KBI1_init();

    #ifdef BREAK_RX_TEN
         SCI2C1_M  = 0;
         SCI2S2_LBKDE = 0;
    #elif defined BREAK_RX_ELEVEN
         SCI2C1_M  = 1;
         SCI2S2_LBKDE = 0;
    #elif defined LIN_BREAK_RX_ELEVEN
         SCI2C1_M  = 1;
         SCI2S2_LBKDE = 1;         
    #elif defined LIN_BREAK_RX_TWELVE
         SCI2C1_M  = 1;
         SCI2S2_LBKDE = 1;
    #else
       #error "NO SCI SUB TEST SELECTED!!!"
    #endif
  
  for(;;) 
  {   
    //SCI2_SendChr('2');
    //__RESET_WATCHDOG(); /* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */
}

#endif